// A função window.electron é uma suposição; ajuste conforme a implementação real do IPC.
window.electron.onUpdateProgress((data) => {
    const progressBar = document.getElementById("progress-bar");
    progressBar.style.width = `${data.percentComplete}%`;
    document.getElementById("status").textContent = `Descompactando arquivos`;
  
    // Exibe a velocidade de download quando o progresso começar
    const speedElement = document.getElementById("speed");
    if (!speedElement.style.display || speedElement.style.display === "none") {
      speedElement.style.display = "block";
    }
  
    // Atualiza o número total de arquivos restantes
    const totalFilesElement = document.getElementById("total-files");
    if (data.totalFiles !== undefined) {
      totalFilesElement.textContent = `Arquivos restantes: ${data.totalFiles}`;
      totalFilesElement.style.display = "block";
    }
  });
  
  window.electron.onUpdateError((error) => {
    document.getElementById("status").textContent = `Erro: ${error}`;
  });
  
  window.electron.onUpdateStatus((status) => {
    document.getElementById("status").textContent = status;
  });
  
  window.electron.onDownloadSpeed((speed) => {
    document.getElementById("speed").textContent = `Velocidade: ${speed} MB/s`;
  });
  