document.addEventListener('DOMContentLoaded', () => {
    const closeButton = document.getElementById('closed');
    if (closeButton) {
        closeButton.addEventListener('click', () => {
            console.log('Close button clicked');
            window.electron.closeWindow();
        });
    }

    const minimizeButton = document.getElementById('minimize');
    if (minimizeButton) {
        minimizeButton.addEventListener('click', () => {
            console.log('Minimize button clicked');
            window.electron.minimizeWindow();
        });
    }

    const settingsCloseButton = document.querySelector('.bg-settings .closed');
    if (settingsCloseButton) {
        settingsCloseButton.addEventListener('click', () => {
            console.log('Settings close button clicked');
            closeSettingsBox();
        });
    }

    const settingsButton = document.getElementById('settings');
    if (settingsButton) {
        settingsButton.addEventListener('click', () => {
            console.log('Settings button clicked');
            openSettingsBox();
        });
    }

    const startButton = document.getElementById('start');
    if (startButton) {
        startButton.addEventListener('click', () => {
            console.log('Start button clicked');
            const exePath = 'main.exe';
            window.electron.startExecutable(exePath);
        });
    }
});

function openSettingsBox() {
    document.querySelector('.bg-settings').style.display = 'block';
    console.log('Settings box opened');
}

function closeSettingsBox() {
    document.querySelector('.bg-settings').style.display = 'none';
    console.log('Settings box closed');
}
